program MDI;

{%DelphiDotNetAssemblyCompiler '$(SystemRoot)\microsoft.net\framework\v1.1.4322\System.Drawing.dll'}
{%DelphiDotNetAssemblyCompiler '$(SystemRoot)\microsoft.net\framework\v1.1.4322\System.Windows.Forms.dll'}

uses
  System.Drawing,
  System.ComponentModel,
  System.Windows.Forms,
  sysutils,
  Document;

type
  { .NET to VCL mapping }
  TMainMenu    = System.Windows.Forms.MainMenu;
  TMenuItem    = System.Windows.Forms.MenuItem;
  TForm        = System.Windows.Forms.Form;
  TStatusBar   = System.Windows.Forms.StatusBar;
  TContextMenu = System.Windows.Forms.ContextMenu;
  TContainer   = System.ComponentModel.Container;
  TSize        = System.Drawing.Size;
  TPoint       = System.Drawing.Point;
  TFont        = System.Drawing.Font;
  TFontFamily  = System.Drawing.FontFamily;

type
  { Application main form }
//  [STAThread]
  TMainForm = class(TForm)
  private
    FComponents: TContainer;
    FWindowCount: Integer;
    procedure InitComponents;
    procedure AddDocument;
    procedure FileAddClicked(Sender: TObject; Args: EventArgs);
    procedure FileExitClicked(Sender: TObject; Args: EventArgs);
    procedure MDIChildActivated(Sender: TObject; Args: EventArgs);
    procedure WindowCascadeClicked(Sender: TObject; Args: EventArgs);
    procedure WindowTileHClicked(Sender: TObject; Args: EventArgs);
    procedure WindowTileVClicked(Sender: TObject; Args: EventArgs);
  published
    MainMenu: TMainMenu;
    StatusBar: TStatusBar;
  public
    constructor Create(Owner: TObject);
    destructor Destroy; override;
  end;

{ TMainForm }

constructor TMainForm.Create(Owner: TObject);
var
  miFile, miAddDoc, miSpace, miExit, miWindow: TMenuItem;
begin
  inherited Create;
  InitComponents;

  //Setup MDI stuff
  IsMdiContainer:= True;
  Add_MdiChildActivate(MDIChildActivated);

  //Add File Menu
  miFile:= mainMenu.MenuItems.Add('&File');
  miFile.MergeOrder:=0;
  miFile.MergeType:= MenuMerge.MergeItems;

  miAddDoc:= TMenuItem.Create('&Add Document', nil, Shortcut.CtrlA);
  miAddDoc.Add_Click(FileAddClicked);
  miAddDoc.MergeOrder:= 100;

  miSpace:= TMenuItem.Create('-', nil, Shortcut.None);
  miSpace.Add_Click(FileExitClicked);
  miSpace.MergeOrder:= 110;

  miExit:= TMenuItem.Create('E&xit', nil, Shortcut.CtrlX);
  miExit.Add_Click(FileExitClicked);
  miExit.MergeOrder:= 115;

  miFile.MenuItems.Add(miAddDoc);
  miFile.MenuItems.Add(miSpace);     // Gives us a seperator
  miFile.MenuItems.Add(miExit);

  //Add Window Menu
  miWindow:= MainMenu.MenuItems.Add('&Window');
  miWindow.MergeOrder:= 10;

  miWindow.MenuItems.Add(TMenuItem.Create('&Cascade', nil, Shortcut.CtrlC));
  miWindow.MenuItems[0].Add_Click(WindowCascadeClicked);

  miWindow.MenuItems.Add(TMenuItem.Create('Tile &Horizontal', nil, Shortcut.CtrlH));
  miWindow.MenuItems[1].Add_Click(WindowTileHClicked);

  miWindow.MenuItems.Add(TMenuItem.Create('Tile &Vertical', nil, Shortcut.CtrlV));
  miWindow.MenuItems[2].Add_Click(WindowTileVClicked);

  miWindow.MdiList:= True ; //Adds the MDI Window List to the bottom of the menu
  
  AddDocument; //Add an initial doc
end;

destructor TMainForm.Destroy;
begin
  if (FComponents <> nil) then
   FComponents.Dispose;
  inherited;
end;

procedure TMainForm.InitComponents;
begin
  SuspendLayout;

  FWindowCount:= 0;
  FComponents:= TContainer.Create;
  MainMenu:= TMainMenu.Create;
  StatusBar:= TStatusBar.Create;
  Text:= 'MDI Example';
  AutoScaleBaseSize:= TSize.Create(5, 13);
  Menu:= MainMenu;
  ClientSize:= TSize.Create(450, 200);
  BackColor:= SystemColors.Control;
  StatusBar.Location:= TPoint.Create(0, 180);
  StatusBar.Size:= TSize.Create(450, 20);
  StatusBar.TabIndex:= 1;
  Controls.Add(StatusBar);

  ResumeLayout(False);
end;

procedure TMainForm.AddDocument;
var
  Doc: TDocument;
begin
 Inc(FWindowCount);
 Doc:= TDocument.Create('Document ' + IntToStr(FWindowCount));
 Doc.MdiParent:= Self;
 Doc.Show;
end;

procedure TMainForm.FileAddClicked(Sender: TObject; Args: EventArgs);
begin
  AddDocument;
end;

// File->Exit Menu item handler
procedure TMainForm.FileExitClicked(Sender: TObject; Args: EventArgs);
begin
  Close;
end;

// One of the MDI Child windows has been activated
procedure TMainForm.MDIChildActivated(Sender: TObject; Args: EventArgs);
begin
  if (ActiveMdiChild = nil) then
    StatusBar.Text:= ''
  else
    StatusBar.Text:= ActiveMdiChild.Text;
end;

// Window->Cascade Menu item handler
procedure TMainForm.WindowCascadeClicked(Sender: TObject; Args: EventArgs);
begin
  LayoutMdi(MdiLayout.Cascade);
end;

// Window->Tile Horizontally Menu item handler
procedure TMainForm.WindowTileHClicked(Sender: TObject; Args: EventArgs);
begin
  LayoutMdi(MdiLayout.TileHorizontal);
end;

// Window->Tile Vertically Menu item handler
procedure TMainForm.WindowTileVClicked(Sender: TObject; Args: EventArgs);
begin
  LayoutMdi(MdiLayout.TileVertical);
end;

var
  MainForm: TMainForm;
begin
  MainForm:= TMainForm.Create(nil);
  Application.Run(MainForm);
  MainForm.Free;
end.
